//
// splitsnap.C



#define PR(x)  cerr << #x << " = " << x << " "
#define PRC(x) cerr << #x << " = " << x << ",  "
#define PRL(x) cerr << #x << " = " << x << "\n"

#include  <stdlib.h>
#include  <math.h>
#ifdef ICC
#define USESTD 1
#endif
#ifdef GCC3
#define USESTD 1
#endif
#ifdef USESTD
#include  <iostream>
using namespace std;
#else
#include  <stdiostream.h>
#endif
#include <string>

#include<fstream.h>
int  pgetopt(int argc, char ** argv,  char * optstr);
void pskipopt();

main(int argc, char ** argv)
{
    ifstream fsnapin;
    int snapin_flag = 0;
    char fname[255];
    ofstream fsnapout;
    int snapout = 0;
    char foname[255];
    int nout = 1;

    extern char *poptarg;
    int c;
    char* param_string = "i:o:n::h";
    foname[0] = '?';
    foname[1] = '\0';
    while ((c = pgetopt(argc, argv, param_string)) != -1){
	switch(c) {
	    case 'i': strcpy(fname,poptarg);
		snapin_flag = 1;
		break;
	    case 'o': strcpy(foname,poptarg);
		snapout = 1;
		break;
	    case 'n': nout = atoi(poptarg);
		break;
	    case 'h':		      
		cerr << "list of options\n";
		cerr << "-i        name of snapshot input file       (no default)\n";
		cerr << "-o        name of snapshot output file      (default: no output)\n";
		cerr << "-n        number of output files            (default: 1)\n";
		cerr << "-h        print this help\n";
		exit(1);
		break;
	}
    }
    if (snapin_flag == 0){
	cerr << "Snapshot input file required (-i)\n";
	exit(1);
    }
    if (snapout == 0){
	cerr << "Snapshot output file required (-i)\n";
	exit(1);
    }
    fsnapin.open(fname,ios::in);
    double time;
    int nbody;
    char read_buffer[512];
    fsnapin.getline(read_buffer,511);
    sscanf(read_buffer,"%d%lf", &nbody, &time);
    int ndiv = nbody/nout;
    int ifirst = 0;
    for(int iout = 0;iout<nout; iout++){
	int nparticles = ndiv;
	if((iout == nout-1)&&(nbody-ifirst > nparticles)) nparticles = nbody-ifirst;
	char work[255];
	sprintf(work,"%sMP%d-%d",foname,nout,iout);
	fsnapout.open(work,ios::out);
	fsnapout << nparticles << " " <<time << endl;
	for(int i = 0;i<nparticles ; i++){
	    fsnapin.getline(read_buffer,511);
	    fsnapout << read_buffer <<endl;
	}
	fsnapout.close();
	ifirst += nparticles;
    }
}
