/*
 * TEST_PREDICTOR_HEX.C
 *
 * test vector generator for predictor in hex
 *
 * Copyright Jun Makino 1998
 *
 * Version 1.0 March 1 1998
 */
#include "grape6sim.h"


ULONG xunit, tunit, err;
ULONG tjlsb, dtjmsb, ix[5], ipred[2], iti;
ULONG ntjlsb, ndtjmsb, nix[5];
ULONG passk4, passk4a, passk3a, passk2a, passk1a, passk3d,
    passk3e, passk2c, passk2d;

double xp[2];
int i, dtjexp;

void reset_testmode()
{
    passk4 =  passk4a =  passk3a =   passk2a =  passk1a =  passk3d =
	passk3e =  passk2c =  passk2d = 0;
}

void init_output()
{
    printf("32 32\n"); /* xunit, tunit */
    reset_testmode();
}
void print()
{
	printf("%8lx %8lx %16lx %8lx %8lx %8lx %8lx %16lx",
	        tjlsb, dtjmsb, iti, ix[4], ix[3], ix[2], ix[1], ix[0]);
	printf(" %1lx %1lx %1lx %1lx %1lx %1lx %1lx %1lx %1lx\n",
	       passk4, passk4a, passk3a, passk2a, passk1a,
	       passk3d,passk3e, passk2c, passk2d);
}

void unit_a_test()
{
    LONG vexp = 62;
    ULONG itdata[2];
    reset_testmode();
    itdata[0] = 0xaaaaaaaaaaaaaaaa;
    itdata[1] = 0x0102040810204080;
    ix[4] = ix[3] = ix[2] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x800000;
    for(dtjmsb=0; dtjmsb<64; dtjmsb++)
	for(tjlsb=0; tjlsb < 2; tjlsb ++){
	    iti = itdata[tjlsb];
	    print();
	}
}

void unit_b_test()
{
    LONG vexp = 62;
    int i, j;
    
    reset_testmode();
    passk4a =  passk3a =   passk2a =  passk1a =  passk3d =
	passk3e =  passk2c =  passk2d = 1;
    dtjmsb = 12;
    tjlsb  = 0;
    ix[3] = ix[2] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x00000;
    for (i = 1; i<0x800; i <<=1){
	for(j = 1; j<0x800; j<<=1){
	    iti = j; ix[4] = i; print();
	    iti = j-1; ix[4] = i; print();
	    iti = j; ix[4] = i-1; print();
	    iti = j^0xfff; ix[4]=i^0xfff ; print();
	}
    }
}
void unit_c_test()
{
    LONG vexp = 62;
    int i, j;
    
    reset_testmode();
    passk4 =  passk3a =   passk2a =  passk1a =  passk3d =
	passk3e =  passk2c =  passk2d = 1;
    dtjmsb = 11;
    tjlsb  = 0;
    iti = 0;
    ix[3] = ix[2] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x00000;
    for (i = 1; i<0x1000; i <<=1){
	ix[4] = i; print();
	ix[4] = i-1; print();
    }
}

void unit_d_test()
{
    LONG vexp = 62;
    unsigned int i, j, k;
    
    reset_testmode();
    passk4 = passk4a =  passk3a =   passk2a =  passk1a =  passk3d =
	passk3e =  passk2c =  passk2d = 1;
    iti = 0;
    ix[2] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x00000;
    k = 0;
    for (i = 1; i<0x2000; i <<=1){
	for(j = 1; j<0x20000; j<<=1){
	    unsigned int isign, jsign;
	    isign = jsign = 0;
	    if (k %2){
		jsign = 0x10000;
	    }
	    if (k %3){
		isign = 0x1000;
	    }
	    ix[3]= j|jsign; ix[4] = i|isign; print();
	    ix[3]= (j-1)|jsign; ix[4] = i|isign; print();
	    ix[3]= j|jsign ; ix[4] = (i-1)|isign; print();
	    ix[3]= j-1; ix[4] = i-1; print();
	    k++;
	}
    }
}



void unit_e_test()
{
    LONG vexp = 62;
    int i, j;
    
    reset_testmode();
        passk2a =  passk1a = passk3e =  passk2c =  passk2d = 1;
    dtjmsb = 16;
    tjlsb  = 0;
    ix[4] = ix[2] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x00000;
    for (i = 1; i<0x20000; i <<=1){
	for(j = 1; j<0x20000; j<<=1){
	    iti = j; ix[3] = i; print();
	    iti = j-1; ix[3] = i; print();
	    iti = j; ix[3] = i-1; print();
	    iti = j^0xffff; ix[3]=i^0xffff ; print();
	}
    }
}

void unit_f_test()
{
    LONG vexp = 62;
    unsigned int i, j, k;
    
    reset_testmode();
    passk4 = passk4a =  passk3a =   passk2a =  passk1a =  passk3d =
	passk3e =  passk2c =  passk2d = 1;
    iti = 0;
    ix[4] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x00000;
    k = 0;
    for (i = 1; i<0x20000; i <<=1){
	for(j = 1; j<0x200000; j<<=1){
	    unsigned int isign, jsign;
	    isign = jsign = 0;
	    if (k %2){
		jsign = 0x100000;
	    }
	    if (k %3){
		isign = 0x10000;
	    }
	    ix[2]= j|jsign; ix[3] = i|isign; print();
	    ix[2]= (j-1)|jsign; ix[3] = i|isign; print();
	    ix[2]= j|jsign ; ix[3] = (i-1)|isign; print();
	    ix[2]= j-1; ix[3] = i-1; print();
	    k++;
	}
    }
}



void unit_g_test()
{
    LONG vexp = 62;
    int i, j;
    
    reset_testmode();
     passk1a =  passk2c =  1;
    dtjmsb = 20;
    tjlsb  = 0;
    ix[4] = ix[2] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x00000;
    for (i = 1; i<0x200000; i <<=1){
	for(j = 1; j<0x200000; j<<=1){
	    iti = j; ix[2] = i; print();
	    iti = j-1; ix[2] = i; print();
	    iti = j; ix[2] = i-1; print();
	    iti = j^0xfffff; ix[2]=i^0xfffff ; print();
	}
    }
}

void unit_h_test()
{
    LONG vexp = 62;
    unsigned int i, j, k;
    ULONG vmask;
    
    reset_testmode();
    passk1a = 1;
    iti = 0;
    ix[4] = ix[3] = ix[0] =0;
    vmask = (vexp << (PRED_V_LEN+1)) | 0x00000;
    k = 0;
    for (i = 1; i<0x200000; i <<=1){
	for(j = 1; j<0x2000000; j<<=1){
	    unsigned int isign, jsign;
	    isign = jsign = 0;
	    if (k %2){
		jsign = 0x1000000;
	    }
	    if (k %3){
		isign = 0x100000;
	    }
	    ix[1]= j|jsign|vmask; ix[2] = i|isign; print();
	    ix[1]= (j-1)|jsign|vmask; ix[2] = i|isign; print();
	    ix[1]= j|jsign|vmask ; ix[2] = (i-1)|isign; print();
	    ix[1]= (j-1)|vmask; ix[2] = i-1; print();
	    k++;
	}
    }
}


void unit_i_test()
{
    LONG vexp = 62;
    int i, j;
    ULONG vmask;
    vmask = (vexp << (PRED_V_LEN+1)) | 0x00000;
    reset_testmode();
    passk2c =  1;
    dtjmsb = 24;
    tjlsb  = 0;
    ix[4] = ix[3] = ix[2] = ix[0] =0;
    for (i = 1; i<0x200000; i <<=1){
	for(j = 1; j<0x200000; j<<=1){
	    iti = j; ix[1] = i|vmask; print();
	    iti = j-1; ix[1] = i|vmask; print();
	    iti = j; ix[1] = (i-1)|vmask; print();
	    iti = j^0xffffff; ix[1]=(i^0xffffff)|vmask ; print();
	}
    }
}


void unit_j_test()
{
    LONG vexp ;
    unsigned int i, j, k;
    ULONG vmask;
    
    reset_testmode();
    passk1a = 1;
    iti = 0;
    ix[4] = ix[3] = ix[2] = 0;
    k = 0;
    for (i = 1; i<0x2000000; i <<=1){
	for(j = 0; j<64; j+=3){
	    unsigned int isign;
	    vexp = (k % 64);
	    vmask = (vexp << (PRED_V_LEN+1)) | 0x00000;
	    isign = 0;
	    if (k %3){
		isign = 0x1000000;
	    }
	    ix[0] = ULONG_ONE <<j; ix[1] = i|isign|vmask; print();
	    ix[0] = (ULONG_ONE <<j)-1; ix[1] = i|isign|vmask; print();
	    ix[1] = (i-1)|isign|vmask; print();
	    k++;
	}
    }
}

void unit_l_test()
{
    LONG vexp = 62;
    int i, j;
    
    reset_testmode();
    passk3e =  passk2c =  passk2d = 1;
    iti = 0;
    ix[4] = ix[2] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x00000;
    for (i = 1; i<0x20000; i <<=1){
	ix[3] = i; print();
	ix[3] = i-1; print();
    }
}

void unit_n_test()
{
    LONG vexp = 62;
    int i, j;
    
    reset_testmode();
    passk3e =   passk2d = 1;
    iti = 0;
    ix[4] = ix[3] = ix[0] =0;
    ix[1] = (vexp << (PRED_V_LEN+1)) | 0x00000;
    for (i = 1; i<0x200000; i <<=1){
	ix[2] = i; print();
	passk2c = 1;
	ix[2] = i; print();
	passk2c = 0;
	ix[2] = i-1; print();
    }
}


main()
{
    init_output();
    unit_a_test();
    unit_b_test();
    unit_c_test();
    unit_d_test();
    unit_e_test();
    unit_f_test();
    unit_g_test();
    unit_h_test();
    unit_i_test();
    unit_j_test();
    unit_l_test();
    unit_n_test();
}



