#ifndef GRAPE6SIM_H
#include <stdlib.h>

#define GRAPE6SIM_H

#ifdef X86
typedef  unsigned long long ULONG;
typedef  long long LONG;
#else
typedef  unsigned long ULONG;
typedef  long LONG;
#endif
/*typedef  unsigned long ULONG;
typedef  long LONG; */
#define LONGSIZE 8
#define LONGBITS 64
#define DTNBITS 24

/* constant table for predictor accuracy */

#define PRED_V_LEN 24
#define PRED_A_LEN 20
#define PRED_A1_LEN 16
/*#define PRED_A2_LEN 12*/
#define PRED_A2_LEN 10
/* changed to 10 bits on Apr 29, 1998!!! */
#define PRED_V_EXP_LEN 7
#define PRED_V_EXP_OFFSET 63


#define PRED_A_MASK 0x1fffff
#define PRED_A1_MASK 0x1ffff
#define PRED_A2_MASK 0x7ff
#define PRED_A_MASK_U ((ULONG)PRED_A_MASK)
#define PRED_A1_MASK_U ((ULONG)PRED_A1_MASK)
#define PRED_A2_MASK_U ((ULONG)PRED_A2_MASK)

#define INTERACTION_F_LEN 24
#define INTERACTION_F_LEN_U ((ULONG) INTERACTION_F_LEN)
#define INTERACTION_POSITION_EXP_OFFSET 512

#define INTERACTION_J_LEN 20
#define INTERACTION_J_LEN_U ((ULONG) INTERACTION_J_LEN)
#define J_ACC_LEN 32
#define CUTOFF_MANTISSA_LEN ((ULONG)12)
#define  POWER_TABLE_SIZE ((ULONG) 512)
#define  POWER_TABLE_ADDRESS ((ULONG) 9)
#define POWER_TABLE_WIDTH ((ULONG) 26)
#define MUL_2 0
#define MUL_3BY2 1
#define MUL_3BY4 2

/* error code for the accumulator */
#define FADD_SINGLE_OVERFLOW 1
#define FADD_ACC_OVERFLOW 2
#define FADD_SINGLE_UNDERFLOW 4
#define FADD_OVERFLOW_MASK (FADD_SINGLE_OVERFLOW | FADD_ACC_OVERFLOW)

#define CUTOFF_TABLE_SIZE 64
#define CUTOFF_TABLE_BITS 6
#define CUTOFF_NUMBER_OF_TABLES 2

#define NNBMAX 256

#define NFORCETESTMODE 16

#define EXP_MASK ((ULONG)0x3ff)

#define FPIPE_SIM 0
#define FPIPE_CTAB_RESET 1
#define FPIPE_CTAB_LINEAR 2
#define FPIPE_CTAB_GAUSS 3


#ifndef _INCLUDE_SYS_
#   define _INCLUDE_SYS_ 
#   include <stdio.h>
#   include <math.h>
#endif

ULONG force_1_round_and_shift(ULONG s, ULONG inbits, ULONG outbits);
ULONG force_1_round_and_shift_grape_float(ULONG s,
					  ULONG inbits,
					  ULONG outbits);

ULONG padd(ULONG * magnitude, /* result magnitude unsigned integer */
	    ULONG * sign, /* result sign unsigned integer (0:positive) */
	    ULONG in1, /* mag of  arg 1 */
	    ULONG sign1, /* sign of arg  1*/
	    ULONG inb1, /* bit length of arg 1*/
	    ULONG in2, /* mag of  arg  2*/
	    ULONG sign2, /* sign of  arg 2*/
	    ULONG inb2, /* bit length of arg 2*/
	    ULONG outb /* bit length of result*/);

ULONG padd_with_sign(ULONG * magnitude, /* result magnitude unsigned integer */
	    ULONG in1, /*  arg 1 (sign+magnitude)*/
	    ULONG inb1, /* bit length of arg 1 (length of mag)*/
	    ULONG in2, /*  arg  2*/
	    ULONG inb2, /* bit length of arg 2*/
	    ULONG outb /* bit length of result*/);

ULONG pmult(ULONG * product, /* resulted delta t in outbits unsigned integer */
	    ULONG dt, /* dt in DTNBITS integer format, max = 1000... */
	    ULONG coef, /* polynomical coef in inbits unsigned int */
	    ULONG inbits, /* word length for input coef */
	    ULONG outbits /* word length for output */);
ULONG pmult_with_sign(ULONG * product, /* resulted delta t in outbits unsigned integer */
	    ULONG dt, /* dt in DTNBITS integer format, max = 1000... */
	    ULONG coef, /* polynomical coef in inbits unsigned int */
	    ULONG inbits, /* word length for input coef */
	    ULONG outbits /* word length for output */);

ULONG pmult_by_constant(ULONG * product, 
			ULONG coef, 
			ULONG mode, 
			ULONG inbits, 
			ULONG outbits );

void print_in_binary(ULONG num, ULONG nbits);

ULONG pmult_with_sign_by_constant(ULONG * product, 
				  ULONG coef, 
				  ULONG mode, 
				  ULONG inbits,
				  ULONG outbits);

void set_debug_level(int);
void dprintf(int debug, char *  fmt, ...);

void decompose_float(ULONG data, ULONG mantissa_bits, ULONG *exponet,
		     ULONG * sign, ULONG * zero, ULONG * mantissa);

ULONG compose_float(ULONG mantissa_bits, ULONG exponet,
		     ULONG  sign, ULONG  zero, ULONG  mantissa);

double convert_grape_float_to_double(ULONG indata, ULONG inbits);
double convert_grape_fixed_to_double(LONG indata, ULONG inbits, LONG offset);
    
ULONG convert_double_to_grape_float(double x, ULONG float_bits);
ULONG convert_float_to_grape_float(float x, ULONG float_bits);

ULONG convert_fixed_to_grape_float(ULONG in, ULONG in_flac_len,
				   ULONG float_bits);
ULONG compare_grape_floats(ULONG in1, ULONG in2, ULONG inbits);

ULONG shorten_mantissa(ULONG in, LONG bits);

ULONG mult( ULONG in1, /* multiplicant */
	    ULONG in2, /* multiplier */
	    ULONG in1bits, /* mantissa length for input 1 */
	    ULONG in2bits, /* mantissa length for input 2 */
	    ULONG outbits); /* mantissa length for output */

ULONG mult_by_3( ULONG in, /* multiplicant */
	    ULONG nbits); /* mantissa length  */

ULONG add( ULONG in1, /* input1 */
	    ULONG in2, /* input2  */
	    ULONG in1bits, /* mantissa length for input 1 */
	    ULONG in2bits, /* mantissa length for input 2 */
	    ULONG outbits); /* mantissa length for output */

ULONG sub( ULONG in1, /* subtractant */
	    ULONG in2, /* subtractor */
	    ULONG in1bits, /* mantissa length for input 1 */
	    ULONG in2bits, /* mantissa length for input 2 */
	    ULONG outbits); /* mantissa length for output */

ULONG subx(LONG in1, /*   arg 1 */
	    LONG in2); /* arg  2*/

ULONG fadd(ULONG f, /* force etc from a particle */
	   LONG * accumulator, /* ACCUMULATOR*/
	   ULONG inbits, /* input mantissa length */
	   LONG offset, /* base value to add to the exponent before shift */
	   ULONG outbits,
	   ULONG clear);
ULONG power_function( ULONG in, /* multiplicant */ 
		      ULONG powerby2,
		      ULONG inbits, /* word length for input 1 */
		      ULONG outbits); /* word length for output */
ULONG low_acc_power_function( ULONG in, /* multiplicant */
		      ULONG powerby2,
		      ULONG inbits, /* word length for input 1 */
		      ULONG outbits); /* word length for output */

  
void set_forcepipe_testmode(ULONG * testmode);

ULONG force(LONG xj[3],
	    ULONG vj[3],
	    ULONG mj,
	    LONG xi[3],
	    ULONG vi[3],
	    ULONG eps2,
	    ULONG h2,
	    ULONG rscale,
	    LONG fscale,
	    LONG jscale,
	    LONG phiscale,
	    ULONG jindex,
	    LONG iindex,
	    ULONG clear, /* !0: clear before add */
	    LONG  acc[3],
	    LONG  jerk[3],
	    LONG  *phi,
	    ULONG * nbflag,
	    ULONG *r2p,
	    ULONG accflags[7]);

typedef  double ((*pcutoff)(double));
double original_cutoff(double x, ULONG table_id);

ULONG grape_low_acc_distance(ULONG r2);
void prepare_cutoff_table(ULONG table_id,
		    ULONG table_size,
		    ULONG zeroth_len,
		    double ((*cutoff)(double)));
void set_gaussian_cutoff();
void reset_cutoff();
void set_linear_cutoff();
void dump_cutoff_table();

ULONG cutoff_function( ULONG in, /* multiplicant */
		      ULONG inbits, /* word length for input 1 */
		       ULONG table_id);
ULONG cutoff_in_grape_float( ULONG in,
			     ULONG inscale,
			     ULONG inbits,
			     ULONG outbits,
			     ULONG table_id);

ULONG inner_product( ULONG v1[3], 
	    ULONG v2[3],
	    ULONG v1len,
	    ULONG v2len,
	   ULONG outlen);

ULONG rsq( ULONG x, 
	    ULONG y,
	    ULONG z,
	    ULONG eps2,
	   ULONG nbits);
ULONG rsq_with_test( ULONG x, 
		     ULONG y,
		     ULONG z,
		     ULONG eps2,
		     ULONG nbits,
		     ULONG testmode);


ULONG convert_predicted_result(double * xp,
			       double * vp,
			       LONG ixp,
			       ULONG ivp,
			       ULONG xunit, /* position resolution= 2**-xunit*/
			       ULONG tunit /* time resolution  */);
ULONG convert_predictor_vector(ULONG *  tjlsb, /* LSB of tj */
			ULONG * dtjmsb, /* location of MSB of delta ti */
			ULONG ix[3][5], /* converted position, vel... */
			double rtj, /* particle time */
			double rdtj, /* particle timestep */
			double x[3], /* position, vel ... */
			double v[3], /* position, vel ... */
			double aby2[3], /* position, vel ... */
			double a1by6[3], /* position, vel ... */
			double a2by18[3], /* position, vel ... */
			ULONG xunit, /* position resolution= 2**-xunit*/
			ULONG tunit /* time resolution=2**-tinit*/);

ULONG predict_with_testmode(ULONG * result, /* result  */
			    ULONG mode, /* 0: position, 1: velocity */
			    ULONG ti, /* present time */
			    ULONG tjlsb, /* LSB of ti */
			    ULONG dtjmsb, /* location of MSB of delta ti */
			    ULONG a2by18, /* a2dot divided by 18 */
			    ULONG a1by6, /* a1dot divided by 6 */
			    ULONG aby2, /* a divided by 2 */
			    ULONG v, /* velocity */
			    ULONG x,  /* position */
			    ULONG passk4, /* copy  A2BY18 to K4 */
			    ULONG passk4a, /* copy K4 to K4A */
			    ULONG passk3a, /* copy K3 to K3A */
			    ULONG passk2a, /* copy K2 to K2A */
			    ULONG passk1a, /* copy K1 to K1A */
			    ULONG passk3d, /* copy K3C to K3D */
			    ULONG passk3e, /* copy K3D to K3E */
			    ULONG passk2c, /* copy K2B to K2C */
			    ULONG passk2d); /* K2C to K2D */

ULONG predict(ULONG * result, /* result  */
	      ULONG mode, /* 0: position, 1: velocity */
	      ULONG ti, /* present time */
	      ULONG tjlsb, /* LSB of ti */
	      ULONG dtjmsb, /* location of MSB of delta ti */
	      ULONG a2by18, /* a2dot divided by 18 */
	      ULONG a1by6, /* a1dot divided by 6 */
	      ULONG aby2, /* a divided by 2 */
	      ULONG v, /* velocity */
	      ULONG x /* position */);

#define ULONG_ONE ((ULONG) 1)
#define LONG_ONE ((LONG) 1)
#define ULONG_ZERO ((ULONG) 0)
#define LONG_ZERO ((LONG) 0)

#define CONVERT_DOUBLE_TO_GRAPE_INT_POS(x,unit)  (rint(ldexp((x),(unit))))
#define CONVERT_GRAPE_INT_POS_TO_DOUBLE(x,unit) \
                    (ldexp((double)(x),-((int)(unit))))

#define DPRINT_GRAPE_FLOAT_F(dbglbl,name,val) \
                    dprintf(dbglbl,"%s = %lx %le\n", \
			    name, val,convert_grape_float_to_double(val,INTERACTION_F_LEN_U))
#define DPRINT_GRAPE_FLOAT_J(dbglbl,name,val) \
                    dprintf(dbglbl,"%s = %lx %le\n", \
			    name, val,convert_grape_float_to_double(val,INTERACTION_J_LEN_U))

ULONG cutoff_table_data(int tabid,/* 0: zeroth, 1: first, 2: sign */
			int tabno,
			int address);
void print_cutoff_table(FILE * fout);

void set_cutoff_table_data(int data,
			   int tabid,/* 0: zeroth, 1: first, 2: sign */
			   int tabno,
			   int address);
     

void print_forcepipe_test_pattern(LONG xj[3],
				  ULONG vj[3],
				  ULONG mj,
				  LONG xi[3],
				  ULONG vi[3],
				  ULONG eps2,
				  ULONG h2,
				  ULONG rscale,
				  LONG fscale,
				  LONG jscale,
				  LONG phiscale,
				  ULONG pindex,
				  LONG iindex,
				  ULONG clear, /* !0: clear before add */
				  LONG  acc[3],
				  LONG  jerk[3],
				  LONG  phi,
				  ULONG nbflag,
				  ULONG r2p,
				  ULONG pmin,
				  ULONG accflags[7]);

void set_and_print_cutoff_table(ULONG command);
#endif

