#ifndef MEMMAP_H
#define MEMMAP_H

/*
#include "../g5pkg/pcimem/pcimem.h"
#define MAXCLUSTERS (4)
*/
#include "pcimem_reg.h"

#ifndef X86
#define MB asm("mb")
#else
#define MB ;
#endif

#define CFG_SIZE   (0x80)
#define REG_SIZE   (0x00000200)
/*#define MEM_SIZE   (0x00100000)*/
/* #define MEM_SIZE   (0x000b0000) --- Used to be this till 2000/4/22 JM */
#define MEM_SIZE   (0x000f0000)
#define DEV_OFFSET (0x00010000)

#ifndef GCC
#include <c_asm.h>
#endif
#define read_shift(address,data,width) \
    { data = ( (data >> ((address & 3) << 3)) & \
             ( (1 << ((8*width)-1)) + ((1L << ((8*width)-1L))-1L) ) ); }

#define read_sparse_byte(base, offset, dest) { \
    unsigned char *va; \
    unsigned long data=0; \
    va = (unsigned char *) ((((u_long)offset) << 5) + \
        ((u_long)base )); \
    data = (unsigned long) *(int *)va; \
    read_shift(((u_long)offset & 3), data, 1); \
    dest = (unsigned char) data; }

#define read_sparse_word(base, offset, dest) { \
    unsigned short *va; \
    unsigned long data=0; \
    va = (unsigned short *) ((((u_long)offset) << 5) + \
        ((u_long)base ) | 8); \
    data = (unsigned long) *(int *)va; \
    read_shift(((u_long)offset & 3), data, 2); \
    dest = (unsigned short) data; }

#define read_sparse_int(base, offset, dest) { \
    unsigned int *va; \
    unsigned long data=0; \
    va = (unsigned int *) ((((u_long)offset) << 5) + \
        ((u_long)base ) | 0x18); \
    data = (unsigned long) *(int *)va; \
    read_shift(((u_long)offset & 3), data, 4); \
    dest = (unsigned int) data; }

#define write_sparse_byte(base, offset,data) { \
    unsigned char *va; \
    unsigned long write_data = \
        (unsigned long) data << (((u_long)offset & 3) << 3); \
    va = (unsigned char *) ((((u_long)offset) << 5) + \
        ((u_long)base )); \
    *(int *)va = write_data; \
    (void)asm("mb"); }

#define write_sparse_word(base,offset,data) { \
    unsigned short *va; \
    unsigned long write_data = \
        (unsigned long) data << (((u_long)offset & 3) << 3); \
    va = (unsigned short *) ((((u_long)offset) << 5) + \
        ((u_long)base ) | 8); \
    *(int *)va = write_data; \
    (void)asm("mb");  }

#define write_sparse_int(base, offset, data) { \
    unsigned int *va; \
    unsigned long write_data = \
        (unsigned long) data << (((u_long)offset & 3) << 3); \
    va = (unsigned int *) ((((u_long)offset) << 5) + \
        ((u_long)base ) | 0x18); \
    *(int *)va = write_data; \
    (void)asm("mb"); }

caddr_t TBopen(int devid, int waittime);
void TBterm(int devid);
unsigned int TBconfigRead(int devid, unsigned int addr);
void TBconfigWrite(int devid, unsigned long addr, unsigned int value);
unsigned int TBmemRead(int devid, unsigned long addr);
unsigned int TBregRead(int devid, unsigned long addr);
void TBregWrite(int devid, unsigned long addr, unsigned int value);
#ifndef X86
unsigned long TBdmaMapLoad(int devid, caddr_t buf, int size);
void TBgetDmaInfo(int devid, unsigned long *pa, unsigned int **va);
#endif
#endif /* MEMMAP_H */
