/*
 * TEST_PREDICTOR.C
 *
 * test vector generator for predictor
 *
 * Copyright Jun Makino 1998
 *
 * Version 1.0 Feb 1 1998
 * -- x to ix seems okay (just shifting... )
 */
#include "grape6sim.h"


    double tj, dtj, ti, x[5], xp[2];
    ULONG xunit, tunit;


void print()
{
    printf("%24.17le %24.17le %24.17le %ld %ld %.6le %.7le %.8le %.9e %24.17le\n",
	   tj, dtj, ti,tunit, xunit, x[0],x[1],x[2],x[3],x[4]);
}
main()
{
  double drand48();
  ULONG i, j, k, l;
  double dti, dtdum;
  /* test for tj shifter */
  tunit = xunit = 62;
  x[0] = x[1] = x[2] = x[3] = x[4] = 1;
  tj = 1;
  dti =  dtj = 1;
  for(i=0;i<62; i++){
    ti = tj+dti;
    print();
    dti *= 0.5;
    for (k = 0; k<5; k++){
      if( (i%(k+2)) == 0) x[k] = -x[k];
    }
  }

  /* test for complex ti */
  tunit = xunit = 56;
  x[0] = x[1] = x[2] = x[3] = x[4] = 1;
  dtdum =  dtj = 1;
  for(i=0;i<62; i++){
    tj = i;
    dtj = 1;
    ti = tj+dtj - dtdum;
    print();
    dtdum *= 0.5;
    for (k = 0; k<5; k++){
      if( (i%(k+2)) == 0) x[k] = -x[k];
    }
  }
  /* test for simple ti & xj */
  tunit = xunit = 56;
  x[0] = x[1] = x[2] = x[3] = x[4] = 1;
  dtdum =  dtj = 0.0625;
  for(i=0;i<62; i++){
    tj = i;
    ti = tj+ dtdum;
    x[1] *= 0.5;
    x[3] *= 0.5;
    print();
    dtdum *= 0.5;
    for (k = 0; k<5; k++){
      if( (i%(k+2)) == 0) x[k] = -x[k];
    }
  }

  /* test for random values of ti, x */
  srand48(12345);
  tunit = xunit = 56;

  dtdum =  dtj = 1;
  for(i=0;i<255; i++){
    tj = i;
    dtj = 0.25;
    ti = tj + drand48()*dtj;
    for (k = 0; k<5; k++){
      x[k] = drand48()*2 - 1;
    }
    print();
  }

  tunit = 48;
  xunit = 56;

  dtdum =  dtj = 1;
  for(i=0;i<255; i++){
    tj = i;
    dtj = 0.25;
    ti = tj + drand48()*dtj;
    for (k = 0; k<5; k++){
      x[k] = drand48()*2 - 1;
    }
    print();
  }
  for(i=0;i<255; i++){
    tj = i;
    dtj = 0.03125;
    ti = tj + drand48()*dtj;
    for (k = 0; k<5; k++){
      x[k] = drand48()*2 - 1;
    }
    print();
  }
}
