	void  init_pred() {
	    pred_pos = pos;
	    pred_vel = vel;
	    t_pred = get_time();
	}

	void  store_old_force() {
	    old_acc = acc;
	    old_jerk = jerk;
	}

	inline void predict_loworder(real t) {		// t is always time
	       if (t_pred < t) {
		    real dt;
		    dt = t - get_time();
		    real dt3 = dt * ONE_THIRD;
		    real dt2 = dt * 0.5;
		    pred_pos = dt*(dt2*(dt3*old_jerk+ old_acc) + vel) + pos;
		    pred_vel = dt*(dt2*old_jerk + old_acc) + vel;
		    
		    t_pred = t;
	       }
	}

	inline void predict_loworder5(real t) {	// t is always time

	    // 5th-order prediction of a top-level node (not checked)

	    if (t_pred < t) {
		real dt = t - get_time();
		real dt3 = dt * ONE_THIRD;
		real dt2 = dt * 0.5;
		pred_pos = dt*(dt2*(dt3*(4.5 * dt * k_over_18  + old_jerk) 
			     	+ old_acc)+ vel) + pos;
		pred_vel = dt*(dt2*(6 * k_over_18 + old_jerk) + old_acc) + vel;
		t_pred = t;
	    }
	}
        inline real get_next_time() {return time + timestep;}
        void correct_and_update(real eta, real max_step_size);
        void update(vector& bt2, vector& at3, real eta, real max_step_size);
        void set_first_timestep(real, real);
        void accumulate_acc_and_jerk(particle* bj, real eps2);
inline void clear_interaction(){
    acc = 0.0;
    jerk = 0.0;
    pot = 0.0;
}
