//particle_io.C
#include "pit_particle.h"
int get_line(istream & s, char * line)
{
    s.get(line,MAX_INPUT_LINE_LENGTH,'\n');
    char c;
    if(s.get(c) && c!='\n'){
	cerr << "get_line : input line too long :"<<line<<endl;
	exit(1);
    }
    return strlen(line);
}

int check_input_line(istream &s, char* reference_string)
{
    char input_line[MAX_INPUT_LINE_LENGTH];
    get_line(s,input_line);
    if(s.eof()){
	cerr << "check_input_line : unexpected EOF, expected ";
	cerr << reference_string <<endl;
	exit(1);
    }
    return !strcmp(input_line,reference_string);
}    

int check_and_skip_input_line(istream &s, char* reference_string)
{
    char input_line[MAX_INPUT_LINE_LENGTH];
    while (! get_line(s,input_line) && !s.eof()){
        if(strcmp(input_line,reference_string) != 0 ){
	        if(s.eof()){
	        return 0;
	    }else{
	        cerr << "Input line must be "<<reference_string;
	        cerr <<", I got " << input_line << endl;
	        exit(1);
	     }
         }
          return 1;
    }    
}    



void set_vector_from_input_line(vector & v, char * input_line)
{
    real vector_component[3];
    sscanf(input_line,"%*s%*s%lf%lf%lf",vector_component,
	   vector_component+1,vector_component+2);
    v=vector(vector_component[0],vector_component[1],vector_component[2]);
}


void particle::read(istream &s)
{
  char input_line[MAX_INPUT_LINE_LENGTH];
    if (!check_input_line(s, "start particle")){
        cerr << " inpossible inpur line ";
        exit(1);
    }
    while (strcmp((get_line(s,input_line),input_line),"end particle")!=0){
	char keyword[MAX_INPUT_LINE_LENGTH];
	char should_be_equal_sign[MAX_INPUT_LINE_LENGTH];
	sscanf(input_line, "%s%s", keyword, should_be_equal_sign);
	if (strcmp("=", should_be_equal_sign)) {
	    cerr << "read: expected =, but got "
		 << should_be_equal_sign
		 << endl;
	    exit(1);
	}
        if(!strcmp("r", keyword))set_vector_from_input_line(pos,input_line);
        if(!strcmp("v", keyword))set_vector_from_input_line(vel,input_line);
        if(!strcmp("m", keyword))sscanf(input_line, "%*s%*s%lf", &mass);
        if(!strcmp("acc", keyword))set_vector_from_input_line(acc,input_line);
        if(!strcmp("pot", keyword))sscanf(input_line, "%*s%*s%lf", &pot);
        if(!strcmp("t", keyword))sscanf(input_line, "%*s%*s%lf", &time);
        if(!strcmp("dt", keyword))sscanf(input_line, "%*s%*s%lf", &timestep);
        if(!strcmp("tpred", keyword))sscanf(input_line, "%*s%*s%lf", &tpred);
        if(!strcmp("jerk", keyword))set_vector_from_input_line(jerk,input_line);
        if(!strcmp("old_acc", keyword))set_vector_from_input_line(old_acc,input_line);
        if(!strcmp("old_jerk", keyword))set_vector_from_input_line(old_jerk,input_line);
        if(!strcmp("k_over_18", keyword))set_vector_from_input_line(k_over_18,input_line);
        if(!strcmp("pred_pos", keyword))set_vector_from_input_line(pred_pos,input_line);
        if(!strcmp("pred_vel", keyword))set_vector_from_input_line(pred_vel,input_line);
        if(!strcmp("t_pred", keyword))sscanf(input_line, "%*s%*s%lf", &t_pred);
        if(!strcmp("i", keyword))sscanf(input_line, "%*s%*s%d", &index);
    }
}
void particle::write(ostream &s)
{
    s << "r = " << pos<<endl;
    s << "v = " << vel<<endl;
    s << "m = " << mass<<endl;
    s << "acc = " << acc<<endl;
    s << "pot = " << pot<<endl;
    s << "t = " << time<<endl;
    s << "dt = " << timestep<<endl;
    s << "tpred = " << tpred<<endl;
    s << "jerk = " << jerk<<endl;
    s << "old_acc = " << old_acc<<endl;
    s << "old_jerk = " << old_jerk<<endl;
    s << "k_over_18 = " << k_over_18<<endl;
    s << "pred_pos = " << pred_pos<<endl;
    s << "pred_vel = " << pred_vel<<endl;
    s << "t_pred = " << t_pred<<endl;
    s << "i = " << index<<endl;
}
