/*
 * movie.c : movie display program
 *
 * J. Makino   89/09/25   Ver. 1.00 (created)
 *
 */
#include <math.h>
#include <stdio.h>
#include <io.h>

static FILE * rasterfile;
static int raster[12000];
static int raster2[16384];
void menu(wait,reverse,expand)
int * wait;
int * reverse;
int * expand;
{
	int keyin;
	fprintf(stderr,"----Movie menu-----\n");
	fprintf(stderr,"q:quit\t\t\ts:speed\n");
	fprintf(stderr,"r:reverse(toggle)\te:expand(toggle)\n");
	keyin = MSDOS_getchar();
	if(keyin == 'q'){
		gquit();
		exit(0);
	}
	if(keyin == 's'){
		fprintf(stderr,"Enter new wait count : ");
		scanf("%d",wait);
		if(*wait < 0)*wait = 0;
		fprintf(stderr,"New wait count = %d\n",*wait);
	}
	if(keyin == 'r'){
		*reverse = ~*reverse;
	}
	if(keyin == 'e'){
		*expand= ~*expand;
	}
	ginit();
}
main()
{
    	static int  n;
    	int x1,x2,y1,y2,cmode;
        int first=1;
        int wait = 0;
        int reverse = 0;
        int expand = 0;
        int i;
 	if(set_input_binary_file(&rasterfile)){
    		puts("raster file open error");
    		exit(1);
    	}
	ginit();
        clear_text_screen();
	for(;;){
		while(!window_get_file(rasterfile,&x1,&y1,&x2,&y2,raster,&cmode)){
			if(first){
				if(cmode) {
					screen(3,0,0,1);
				}else{
					screen(2,0,0,1);
				}
				first = 0;
			}
			if(reverse)window_reverse(x1,y1,x2,y2,raster,cmode);
			if(expand){
				window_expand(x1,y1,x2,y2,raster,raster2,cmode);
				x1*=2; x2*=2; y1*=2; y2*=2;
				x2++; y2++;
			}
			window_getput(x1,y1,x2,y2,raster,1,cmode);
			for(i=0;i<=wait;i++){
				if(key_pressed()){
					menu(&wait,&reverse,&expand);
					first=1;
				}
			}
		}
		fseek(rasterfile,0L,0);		
    	}
}
    
