#
# getstat.awk : get cost/accuarcy information from pit output
BEGIN{
  tset = 0;
  wset = 0;
}
/Time=/{
  n = $NF
  time = $2
}

/CPU time for reinitialization/{
  cpu0 = $NF
}
/steps =/{
  nsteps = $3 ;
  nupdates = $6;
  ttint = $9 - cpu0;
  if (tset == 0){
    tset = 1;
    cpu0 = $9;
  }
}
/steps on proc 0/{
  w = $NF - w0
  if (wset == 0){
    w0 = $NF;
    wset = 1;
  }
}
END{
  if (wset == 1) ttint = w;
    printf("%s%5d %s%7.3f %s%8.3f %s%7d,%5d %s%8.2f %6.1fGflops\n","N=", n, \
      "TSTOP=",time, "TCPU=", ttint, "STPS=", nsteps, nupdates,\
    "steps/sec=",nsteps/ttint, nsteps/ttint*n/1e9*60)
}
