#OPTFLAGS = -O  -funroll-loops -ffast-math
OPTFLAGS = -O -fp_reorder  -fast
CCCFLAGS = $(CPPFLAGS) $(OPTFLAGS)
#CCC = g++   $(CCCFLAGS)
#CCC = /usr/decfw40/bin/g++   $(CCCFLAGS)
CCC = cxx  $(CCCFLAGS)
MPICCC = mpiCC $(CCCFLAGS)

GRAPE6DIR = ../g6hib
GRAPE6LIB = -static  -L/usr2/makino/src/g6hib/ -lg6la  -L/usr2/makino/src/grape6 -lg6lasim2  -lm

pit_system.h : system_def.nbl  pit_system_additions.h \
                pit_system_local_members.h \
                pit_system_io_additions.C \
                pit_system_write_additions.C \
                pit_system_read_additions.C generate_class.awk
	awk -f generate_class.awk system_def.nbl
pit_particle.h : particle_def.nbl  pit_particle_additions.h \
                pit_particle_local_members.h \
                pit_particle_io_additions.C \
                pit_particle_write_additions.C \
                pit_particle_read_additions.C generate_class.awk
	awk -f generate_class.awk particle_def.nbl
HEADERS = pit_system.h pit_particle.h
BASELIBOBJS =  pit_system_io.o pit_particle_io.o time.o pgetopt.o
STDLIBOBJS =  $(BASELIBOBJS)   pit_MP.o
MPILIBOBJS =  $(BASELIBOBJS)   pit_MP_MPI.o
all : pit_MPI pit
	rsync -avprog /home/makino/src/pit makino:/home/makino/src
	rcp  /home/makino/data6/PDS/mpich/mpich-1.2.1/util/machines/machines.LINUX makino:/home/makino/data6/PDS/mpich/mpich-1.2.1/util/machines/machines.LINUX
iotest : pit_system.h pit_particle.h iotest.C time.C
	$(CCC) -o iotest iotest.C pit_system_io.C pit_particle_io.C time.C
pit_l : $(STDLIBOBJS) pit.o pit_hostonly.o 
	$(CCC) -non_shared -o pit_l pit.o $(STDLIBOBJS) pit_hostonly.o -lm
pit_grape6_l : $(STDLIBOBJS) pit.o pit_grape6.o 
	$(CCC) -o pit_grape6_l pit.o $(STDLIBOBJS) pit_grape6.o $(GRAPE6LIB)
pit_MPI_l : $(MPILIBOBJS) pit.o pit_hostonly.o 
	$(MPICCC) -o pit_MPI_l pit.o  $(MPILIBOBJS) pit_hostonly.o  -lm
pit_grape6_MPI_l : $(MPILIBOBJS) pit.o pit_grape6.o 
	$(MPICCC) -o /var/tmp/pit_grape6_MPI_l pit.o  $(MPILIBOBJS) pit_grape6.o\
                $(GRAPE6LIB) -lm
	\mv /var/tmp/pit_grape6_MPI_l   pit_grape6_MPI_l 
splitpitsnap : $(STDLIBOBJS) splitpitsnap.C
	$(CCC) -o splitpitsnap splitpitsnap.C  $(STDLIBOBJS)
mergepitsnap : $(STDLIBOBJS) mergepitsnap.C
	$(CCC) -o mergepitsnap mergepitsnap.C  $(STDLIBOBJS)
pit.o : pit.C $(HEADERS)
	$(CCC) -c pit.C
pit_system_io.o : pit_system_io.C $(HEADERS)
	$(CCC) -c pit_system_io.C
pit_particle_io.o : pit_particle_io.C $(HEADERS)
	$(CCC) -c pit_particle_io.C
time.o : time.C $(HEADERS)
	$(CCC) -c time.C
pgetopt.o : pgetopt.C $(HEADERS)
	$(CCC) -c pgetopt.C
pit_hostonly.o : pit_hostonly.C $(HEADERS)
	$(CCC) -c pit_hostonly.C
pit_grape6.o : pit_grape6.C $(HEADERS)
	$(CCC) -I$(GRAPE6DIR) -c pit_grape6.C
pit_MP_MPI.o : pit_MP_MPI.C $(HEADERS)
	$(MPICCC) -c pit_MP_MPI.C
pit_MP.o : pit_MP.C $(HEADERS)
	$(CCC) -c pit_MP.C






