TARGET = pcimem
CC = /usr/bin/gcc

# choose appropriate CFLAGS according to your kernel configuration
#
CFLAGS = -v -o $@ -c -D__KERNEL__ -DMODULE -D__SMP__ -O -Wall  -DCONFIG_ALPHA_IRONGATE -DUSE_48_BIT_KSEG
# CFLAGS = -o $@ -c -D__KERNEL__ -DMODULE -D__SMP__ -DCONFIG_X86_LOCAL_APIC -O -Wall
# CFLAGS = -o $@ -c -D__KERNEL__ -DMODULE -D__SMP__ -O -Wall
# CFLAGS = -o $@ -c -D__KERNEL__ -DMODULE -O -Wall

all:	$(TARGET).o

$(TARGET).o:	$(TARGET).c $(TARGET).h
	$(CC)  $(CFLAGS) $<

install:
	cp $(TARGET).h /usr/local/include/$(TARGET).h

installmodule:
	./install.csh $(TARGET)

uninstallmodule:
	./uninstall.csh $(TARGET)

clean:
	-rm -f *.o core

bak:
	tar cvf $(TARGET)_linux.tar ./*.template ./*.[ch] ./*.csh
	gzip $(TARGET)_linux.tar
