/*
 * ADD.C
 *
 * generic float adder 
 *
 * function add
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Nov 5 1997
 *
 * Version 1.1 March 7 1998
 * BUG FIX... handle the case of both arguments are 0
 *
 */
#include "grape6sim.h"

ULONG sub( ULONG in1, /* subtractor input 1 */
	    ULONG in2, /* subtractor input 2 */
	    ULONG in1bits, /* mantissa length for input 1 */
	    ULONG in2bits, /* mantissa length for input 2 */
	    ULONG outbits) /* mantissa length for output */
{
  ULONG exp2, sign2,  zero2, mantissa2;

  decompose_float(in2, in2bits, &exp2, &sign2, &zero2, &mantissa2);
  sign2 ^= ULONG_ONE;
  in2 = compose_float(in2bits,  exp2, sign2, zero2, mantissa2);
  return add(in1, in2, in1bits, in2bits, outbits);
}
ULONG add( ULONG in1, /* adder input 1 */
	    ULONG in2, /* adder input 2 */
	    ULONG in1bits, /* mantissa length for input 1 */
	    ULONG in2bits, /* mantissa length for input 2 */
	    ULONG outbits) /* mantissa length for output */
{
  ULONG exp1, exp2, sign1,sign2, zero1, zero2, mantissa1, mantissa2,
    exponent, sign, zero, mantissa;
  ULONG tmp, swap = 0;
  ULONG exp_adjust = 0;
  int n2;
  int iloc, i;
  decompose_float(in1, in1bits, &exp1, &sign1, &zero1, &mantissa1);
  decompose_float(in2, in2bits, &exp2, &sign2, &zero2, &mantissa2);

  /* first, swap in1 and in2 if in1 < in2 */
  
  if(zero1 ) swap = 1; /* here I assume that the data is 0 if
			  zero flag is SET */
  if (exp1 < exp2){
    if(zero2 ==0) swap = 1;
  }
  if(exp2 == exp1){
    if ((zero2==0) &&(mantissa2 > mantissa1)){
      swap = 1;
    }
  }
  dprintf(3, "in1 = %lx %lx %lx %lx\n", exp1, sign1, zero1, mantissa1);
  dprintf(3, "in2 = %lx %lx %lx %lx\n", exp2, sign2, zero2, mantissa2);
  if (swap){
    tmp = exp1; exp1 = exp2; exp2 = tmp;
    tmp = sign1; sign1 = sign2; sign2 = tmp;
    tmp = zero1; zero1 = zero2; zero2 = tmp;
    tmp = mantissa1; mantissa1 = mantissa2; mantissa2 = tmp;
  }
  dprintf(3, "after swap = %d\n", swap);
  dprintf(3, "in1 = %lx %lx %lx %lx\n", exp1, sign1, zero1, mantissa1);
  dprintf(3, "in2 = %lx %lx %lx %lx\n", exp2, sign2, zero2, mantissa2);
  sign = sign1;
  zero = zero1;
  /* shift out the mantissa of the second arg*/
  n2 = in1bits + exp2 - exp1;
  if (n2 > 0){
    mantissa2 = force_1_round_and_shift(mantissa2, in2bits, (ULONG) n2);
  }else{
    mantissa2 = 0;
  }

  if(zero2 == 1) mantissa2 = 0;
  if (sign1 == sign2){
    mantissa =   mantissa1 + mantissa2;
  }else{
    mantissa =   mantissa1 - mantissa2;
  }
  dprintf(3, "new man = %lx %lx\n",n2, mantissa);
  /* count leading zeros */
  
  iloc = in1bits;
  
  while((((ULONG_ONE<<iloc)&mantissa)==0) && (iloc >= 0)) {
    iloc --;
  }
  if(iloc < in1bits){
    mantissa <<= (((int)in1bits)-iloc);
  }
  dprintf(3, "n2, iloc = %x %lx %lx\n",n2, iloc, mantissa);
  exponent = exp1+1-(in1bits - iloc);
  if((mantissa == ULONG_ZERO) ) zero = 1;
  mantissa = force_1_round_and_shift(mantissa, in1bits+1, outbits);
  dprintf(3, "out = %lx %lx %lx %lx\n", exponent, sign, zero, mantissa);

  return compose_float(outbits,  exponent, sign, zero, mantissa);
}
#ifdef ITEST
main()
{
  ULONG  in1, in2, inb1, inb2, outb, product;
  printf("enter in1, in2, inb1, inb2, outb: ");
  scanf("%lx%lx%ld%ld%ld",&in1, &in2, &inb1, &inb2, &outb);
  product =  add(in1, in2,  inb1, inb2,  outb);
  printf("in1, in2,  inb1, inb2, outb, product  = 0x%lx 0x%lx %ld %ld %ld 0x%lx\n",
	 in1, in2, inb1, inb2, outb, product);
}
#endif
#ifdef VECTTEST
main()
{
  ULONG  in1, in2, inb1, inb2, outb, product;
  inb1 = inb2 = outb = BITS;
  scanf("%lx%lx",&in1, &in2);
  product =  add(in1, in2,  inb1, inb2,  outb);
  printf("%lx %lx %lx\n", in1, in2,  product);
}
#endif

#ifdef TEST
main()
{
  ULONG  in1, in2, inb1, inb2, outb, sum ;
  double in1f, in2f, realsum, gsum, err;
  set_debug_level(4);
  printf("enter in1f, in2f, inb1, inb2, outb: ");
  scanf("%le%le%ld%ld%ld",&in1f, &in2f, &inb1, &inb2, &outb);
  in1 = convert_double_to_grape_float(in1f, inb1);
  in2 = convert_double_to_grape_float(in2f, inb2);
  printf("in1 = %le %lx %le\n",	 in1f,
	 in1, convert_grape_float_to_double(in1, inb1));
  printf("in2 = %le %lx %le\n",	 in2f,
	 in2, convert_grape_float_to_double(in2, inb2));
  sum =  add(in1, in2,  inb1, inb2,  outb);
  realsum  = in1f+in2f;
  gsum = convert_grape_float_to_double(sum, outb);
  if(realsum != 0.0){
    err = (gsum - realsum)/realsum;
  }else{
    err = (gsum - realsum);
  }
  printf("outb, sum  = %ld 0x%lx %le %le %le\n",
	  outb, sum, realsum, gsum, err);
}
#endif
#ifdef COMPLEXTEST
main()
{
  ULONG  in1, in2, inb1, inb2, outb, sum, maxbits, ibits ;
  int ntest, i, itest, iscale;
  double in1f, in2f, realsum, gsum, err;
  double errsum, err2sum;
  printf("enter nbits, ntest: ");
  scanf("%ld%d", &maxbits, &ntest);
  inb1 = inb2 = outb;

  for(ibits = 6; ibits <= maxbits; ibits++){
    itest = 0;
    iscale = 2;
    errsum = err2sum = 0.0;
    srand48((long)12345);
      inb1 = inb2 = outb = ibits;
    for(i=0;i<ntest;i++){
      in1f = drand48();
      in2f = drand48();
/*      if(ibits == 10 && (i > 8192))set_debug_level(4);*/
      in1 = convert_double_to_grape_float(in1f, inb1);
      in2 = convert_double_to_grape_float(in2f, inb2);
      dprintf(5,"in1 = %22.16le %lx %le\n",	 in1f,
	      in1, convert_grape_float_to_double(in1, inb1));
      dprintf(5,"in2 = %22.16le %lx %le\n",	 in2f,
	      in2, convert_grape_float_to_double(in2, inb2));
      sum =  add(in1, in2,  inb1, inb2,  outb);
      realsum = in1f+in2f;
      gsum = convert_grape_float_to_double(sum, outb);
      if(realsum != 0.0){
	err = (gsum - realsum)/realsum;
	itest ++;
	errsum += err;
	err2sum += err*err;
	if (fabs(err) > 0.1){
	  printf("in1 = %22.16le %lx %le\n",	 in1f,
		 in1, convert_grape_float_to_double(in1, inb1));
	  printf("in2 = %22.16le %lx %le\n",	 in2f,
		 in2, convert_grape_float_to_double(in2, inb2));
	  printf("outb, sum  = %ld 0x%lx %le %le %le\n",
		 outb, sum, realsum, gsum, err);
	  fflush(stdout);
	}
	
	
      }
      if (itest == iscale){
	printf("nbits, ntest, err, rms error = %d %d %le %le %le %le\n",
	       outb, itest, errsum, err2sum, errsum/itest, sqrt(err2sum/itest));
	  fflush(stdout);
	iscale *= 2;
      }
    }
  }
}

#endif

