/*
 * normalize.C
 *
 * generic float nomalizer
 *
 * function normalize
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Nov 17 1997
 *
 */
#include "grape6sim.h"

ULONG normalize( ULONG in, /* multiplicant */
	    ULONG inbits, /* word length for input 1 */
	    ULONG outbits) /* word length for output */
{
  ULONG exp1,  sign1, zero1,  mantissa1, 
    exponent, sign, zero, mantissa;
  ULONG tmp,  exp_adjust = 0;
  int n2;
  int iloc;
  decompose_float(in, inbits, &exp1, &sign1, &zero1, &mantissa1);
  dprintf(3, "in = %lx %lx %lx %lx\n", exp1, sign1, zero1, mantissa1);
  sign = sign1;
  zero = zero1;
  iloc = inbits;
  /* shift out the mantissa of the second arg*/
  mantissa =   mantissa1;
  /* count leading zeros */
  iloc = inbits;
  while((((ULONG_ONE<<iloc)&mantissa)==0) && (iloc >= 0)) {
    iloc --;
  }
  if(iloc < inbits){
    mantissa <<= (((int)inbits)-iloc);
  }
  dprintf(3, "iloc =  %lx %lx\n", iloc, mantissa);
  exponent = exp1+1-(inbits - iloc);
  if(mantissa == ULONG_ZERO) zero = 0;
  mantissa = force_1_round_and_shift(mantissa, inbits+1, outbits);
  dprintf(3, "out = %lx %lx %lx %lx\n", exponent, sign, zero, mantissa);

  return compose_float(outbits,  exponent, sign, zero, mantissa);
}
#ifdef TEST
main()
{
  ULONG  in1,  inb1,  outb, product;
  printf("enter in1,  inb1, outb: ");
  scanf("%lx%ld%ld",&in1, &inb1, &outb);
  product =  normalize(in1,  inb1,  outb);
  printf("in1,   inb1, outb, product  = 0x%lx %ld %ld 0x%lx\n",
	 in1, inb1,	 outb, product);
   printf("%21.14e %21.14e %21.14e\n",
	  convert_grape_float_to_double(in1, inb1),
	  convert_grape_float_to_double(product, outb),
	  convert_grape_float_to_double(in1, inb1)
	  -convert_grape_float_to_double(product, outb));

}
#endif

#ifdef REALTEST
main()
{
  ULONG  in1, in2, inb1, inb2, outb, sum ;
  double in1f, in2f, realsum, gsum, err;
  set_debug_level(4);
  printf("enter in1f, in2f, inb1, inb2, outb: ");
  scanf("%le%le%ld%ld%ld",&in1f, &in2f, &inb1, &inb2, &outb);
  in1 = convert_double_to_grape_float(in1f, inb1);
  in2 = convert_double_to_grape_float(in2f, inb2);
  printf("in1 = %le %lx %le\n",	 in1f,
	 in1, convert_grape_float_to_double(in1, inb1));
  printf("in2 = %le %lx %le\n",	 in2f,
	 in2, convert_grape_float_to_double(in2, inb2));
  sum =  add(in1, in2,  inb1, inb2,  outb);
  realsum  = in1f+in2f;
  gsum = convert_grape_float_to_double(sum, outb);
  if(realsum != 0.0){
    err = (gsum - realsum)/realsum;
  }else{
    err = (gsum - realsum);
  }
  printf("outb, sum  = %ld 0x%lx %le %le %le\n",
	  outb, sum, realsum, gsum, err);
}
#endif
