//
// pit_hostonly.C
//
// Version 2001/3/11 Jun Makino
//
// serves host-only version of calculate_acc_and_jerk_for_list
//
// *should not* do anything more complecated in here.

#include "pit_system.h"

void MP_add_acc_and_jerk_for_list_from_other_host(particle* pb,
						       int nbody,
						       int nbh,
						       node_time* nt, 
						       int  n_next,
						       real eps2,
						       int nprocs,
						       int myid);

void calculate_acc_and_jerk_for_list_on_host(particle* pb,
					     int nbody,
					     int nbh,
					     node_time* nt, 
					     int  n_next,
					     real eps2,
					     bool &restart_grape)
{
    //    cerr << "Enter calculate_acc_and_jerk_for_list_on_host" << endl;

    real sys_t = nt[0].next_time;
    int i,j;
    for (i = 0; i < n_next; i++) {
	particle *bi = nt[i].pptr;
	bi->predict_loworder(sys_t);
	bi->clear_interaction();
    }
    for (i = 0; i < n_next; i++) {
	particle *bi = nt[i].pptr;
	particle *bj = pb;
	for(j=0;j<nbody;j++,bj++){
	    real epstmp2 = eps2;
	    if ((bi->get_index() <nbh)||(  bj->get_index()<nbh))epstmp2 = EPS2BH;
	    if (bi->get_index() != bj->get_index())bi->accumulate_acc_and_jerk(bj,epstmp2);
	}
    }
}

void particle_system::calculate_acc_and_jerk_for_list(int n_next,
						      bool &restart_grape)
{
    //    cerr << "Enter calculate_acc_and_jerk_for_list" << endl;
    
#ifndef USE_GRAPE
    predict_loworder_all(time);	
#endif
    int nbh_for_force_calculation = 0;
    if (myprocid == 0) nbh_for_force_calculation = nbh;
    calculate_acc_and_jerk_for_list_on_host(pb, n, nbh_for_force_calculation,
					    nt, n_next, eps2,restart_grape);
    MP_add_acc_and_jerk_for_list_from_other_host(pb, n, nbh, nt, n_next,
					     eps2,nprocessors,myprocid);
}

void particle_system::update_grape_data(int  n_next)
{
}

void close_grape(){}

