#!/bin/awk -f
#
# generate_class.awk
# NBL class header & other functions generator
#
BEGIN{
  icount = 0;
}

{
  if (substr($1,1,1) == "#" || NF < 1) next;
  if ($1 == "class"){
    class_name = $2;
    next;
  }
  if ($1 == "fname"){
    file_name_base = $2;
    full_header_name = file_name_base ".h"
    symbol_name = toupper(file_name_base) "_H"
    next;
  }
  if ($1 == "start"){
    if ($2 == "protected"){
      protected = 1;
      member_count = 0;
      next;
    }
  }
  if ($1 == "end"){
    if ($2 == "protected"){
      protected = 0;
      next;
    }
  }
  if (protected ==1){
    member_type[member_count] = $1;
    member_name[member_count] = $2;
    member_iokey[member_count] = $2;
    member_olevel[member_count] = 0;
    if ($1 == "vector" ||$1 == "real")	member_initval[member_count] = "0.0";
    if ($1 == "int" )	member_initval[member_count] = "0";

    for(i = 3;i<=NF;i++){
      if (substr($i,1,6)=="IOKEY="){
	member_iokey[member_count] = substr($i,7,99);
      }
      if (substr($i,1,7)=="OLEVEL="){
	member_olevel[member_count] = substr($i,8,99);
      }
      if (substr($i,1,8)=="INITVAL="){
	member_initval[member_count] = substr($i,9,99);
      }
    }
    member_count += 1;
  }
  if ($1 == "include"){
    include_file[icount] = $2;
    icount += 1;
  }
}
END{

#
# create header
#
  print "#ifndef " symbol_name >full_header_name;
  print "#  define " symbol_name >full_header_name;
  print "//"  >full_header_name;
  print "//" full_header_name >full_header_name;
  print "// generated by generate_class.awk"  >full_header_name;
  print "//"  >full_header_name;
  print "#  define real double"> full_header_name;
  print "#  define local static"> full_header_name;
  print "#  define MAX_INPUT_LINE_LENGTH 1024"> full_header_name;
  printf("#include <stdlib.h>\n") >full_header_name;
  printf("#include <math.h>\n") >full_header_name;
  printf("#include <stdiostream.h>\n") >full_header_name;
  printf("#include \"vector.h\"\n") >full_header_name;
  for (i=0;i<icount;i++){
    printf("#include \""include_file[i]".h\"\n") >full_header_name;
  }
  print "class " class_name >full_header_name;
  print "    {" >full_header_name;
  print "    private:" >full_header_name;
  for(i=0;i<member_count; i++){
    print "        " member_type[i], member_name[i] ";" >full_header_name;
  }
  print "public:" >full_header_name;
  print "        "class_name"(){" >full_header_name;
  for(i=0;i<member_count;i++){
    print "            "member_name[i] "=" member_initval[i],";" >full_header_name;
  }
  print "        }" >full_header_name;
  for(i=0;i<member_count;i++){
    print "        void set_" member_name[i]"("member_type[i] " newval){"member_name[i]"=newval;}" >full_header_name;
    print "        "member_type[i] " get_" member_name[i]"(){return "member_name[i]";}" >full_header_name;
    print "        "member_type[i] "* pget_" member_name[i]"(){return &"member_name[i]";}" >full_header_name;
      
  }
  print"	int read(istream & );">full_header_name;
  print"	void write(ostream & s, int olevel=0 );">full_header_name;
  print"#include \"" file_name_base "_local_members.h\"">full_header_name;
  print "};" >full_header_name;
  print"#include \"" file_name_base "_additions.h\"">full_header_name;
  print "#endif //" symbol_name >full_header_name;

#create I/O functions
#
# I/O full file format
# start class_name
# member_iokey = val
# end class_name
# assumption for read: the first line is the start line
  iofname= file_name_base "_io.C";
  print "//" iofname>iofname;
  print "#include \"" full_header_name "\"">iofname;

# some basic functions

print "local int get_line(istream & s, char * line)">iofname;
print "{">iofname;
print "    s.get(line,MAX_INPUT_LINE_LENGTH,'\\n');">iofname;
print "    char c;">iofname;
print "    if(s.get(c) && c!='\\n'){">iofname;
print "	cerr << \"get_line : input line too long :\"<<line<<endl;">iofname;
print "	exit(1);">iofname;
print "    }">iofname;
print "    return strlen(line);">iofname;
print "}">iofname;
print "">iofname;
print "local int check_input_line(istream &s, char* reference_string)">iofname;
print "{">iofname;
print "    char input_line[MAX_INPUT_LINE_LENGTH];">iofname;
print "    get_line(s,input_line);">iofname;
print "    if(s.eof()){">iofname;
print "	       return 99;">iofname;
print "    }">iofname;
print "    return !strcmp(input_line,reference_string);">iofname;
print "}    ">iofname;
print "">iofname;
print "local int check_and_skip_input_line(istream &s, char* reference_string)">iofname;
print "{">iofname;
print "    char input_line[MAX_INPUT_LINE_LENGTH];">iofname;
print "    while (! get_line(s,input_line) && !s.eof()){">iofname;
print "        if(strcmp(input_line,reference_string) != 0 ){">iofname;
print "	        if(s.eof()){">iofname;
print "	        return 0;">iofname;
print "	    }else{">iofname;
print "	        cerr << \"Input line must be \"<<reference_string;">iofname;
print "	        cerr <<\", I got \" << input_line << endl;">iofname;
print "	        exit(1);">iofname;
print "	     }">iofname;
print "         }">iofname;
print "          return 1;">iofname;
print "    }    ">iofname;
print "    return 0;">iofname;
print "}    ">iofname;
print "">iofname;
print "">iofname;
print "">iofname;
print "local void set_vector_from_input_line(vector & v, char * input_line)">iofname;
print "{">iofname;
print "    real vector_component[3];">iofname;
print "    sscanf(input_line,\"%*s%*s%lf%lf%lf\",vector_component,">iofname;
print "	   vector_component+1,vector_component+2);">iofname;
print "    v=vector(vector_component[0],vector_component[1],vector_component[2]);">iofname;
print "}">iofname;
print "">iofname;
print "">iofname;

# read function
  print "int " class_name "::read(istream &s)">iofname;
  print "{">iofname;
  print "  char input_line[MAX_INPUT_LINE_LENGTH];">iofname;
  print "    int status = check_input_line(s, \"start " class_name "\");">iofname;
  print "    if (status == 99){">iofname;
  print "        return 1;">iofname;
  print "    }">iofname;
  print "    if (!status ){">iofname;
  print "        cerr << \" impossible input line \";">iofname;
  print "        exit(1);">iofname;
  print "    }">iofname;
  print "    while (strcmp((get_line(s,input_line),input_line),\"end "class_name"\")!=0){">iofname;
  print "	char keyword[MAX_INPUT_LINE_LENGTH];">iofname;
  print "	char should_be_equal_sign[MAX_INPUT_LINE_LENGTH];">iofname;
  print "	sscanf(input_line, \"%s%s\", keyword, should_be_equal_sign);">iofname;
  print "#include \"" file_name_base "_read_additions.C\"">iofname;
  
  print "	if (strcmp(\"=\", should_be_equal_sign)==0) {">iofname;
  for (i=0;i<member_count;i++) if(substr(member_type[i],length(member_type[i]),1) != "*") {
    printf( "            if(!strcmp(\""member_iokey[i]"\", keyword))")>iofname;
    if (member_type[i] == "real"){
      print "sscanf(input_line, \"%*s%*s%lf\", &" member_name[i]");">iofname;
    }
    if (member_type[i] == "int"){
      print "sscanf(input_line, \"%*s%*s%d\", &" member_name[i]");">iofname;
    }
    if (member_type[i] == "vector"){
      print "set_vector_from_input_line(" member_name[i]",input_line);">iofname;
    }
  }
print "        }">iofname;
print "    }">iofname;
print "    return 0;">iofname;
  
print "}">iofname;
  
# write function
  print "void " class_name "::write(ostream &s, int olevel)">iofname;
  print "{">iofname;
  print "    s << \"start " class_name "\" <<endl;">iofname;
  for (i=0;i<member_count;i++)if(substr(member_type[i],length(member_type[i]),1) != "*"){
    print "    if ((olevel >= " member_olevel[i] ")&&("member_olevel[i] ">=0)){">iofname;
    print "        s << \"" member_iokey[i] " = \" << " member_name[i] "<<endl;">iofname;
    print "    }">iofname;
  }
  print "#include \"" file_name_base "_write_additions.C\"">iofname;
  print "    s << \"end " class_name "\"<<endl;">iofname;
  
print "}">iofname;

  print "#include \"" file_name_base "_io_additions.C\"">iofname;

}  
    
    



